﻿using System;

namespace CSharpBuch.Kap07
{
  class Aufgabe3
  {
    static void Main(string[] args)
    {
      SportVerein sv = new SportVerein("SV Alle Neune", 28, 12.00, "Kegeln", "Frau Schmidt", 90.00);
      Ausgaben(sv);
      TierVerein tv = new TierVerein("Hoppel", 32, 7.50, "Kaninchen", "Riesenschecken");
      Ausgaben(tv);
      Console.ReadLine();
    }
    static void Ausgaben(Verein v)
    {
      Console.WriteLine(v.VereinsDaten());
      Console.WriteLine("Anzahl Mitglieder geändert: " + v.AnzahlAendern(2));
      Console.WriteLine("Einnahmen: " + v.Einnahmen());
    }
  }

  class Verein
  {
    protected string name;
    protected int anzahlMG;
    protected double beitrag;

    public Verein(string name, int anzahlMitglieder, double beitragshoehe)
    {
      this.name = name;
      anzahlMG = anzahlMitglieder;
      beitrag = beitragshoehe;
    }

    public virtual string VereinsDaten()
    {
      return ("Verein: " + name + " hat " + anzahlMG +
              " Mitglieder, Beitragssatz: " + beitrag);
    }

    public virtual double Einnahmen()
    {
      return (anzahlMG * beitrag);
    }

    public int AnzahlAendern(int i)
    {
      if ((i + anzahlMG) < 0)
        return (0);

      return (anzahlMG + i);
    }
  }

  class SportVerein : Verein
  {
    protected string sportart;
    protected string trainer;
    protected double objektMiete;

    public SportVerein(string name, int anzahlMitglieder, double beitragshoehe,
                       string sportart, string trainer, double objektMiete)
      : base(name, anzahlMitglieder, beitragshoehe)
    {
      this.sportart = sportart;
      this.trainer = trainer;
      this.objektMiete = objektMiete;
    }

    public override double Einnahmen()
    {
      return (anzahlMG * beitrag - objektMiete);
    }
    public override string VereinsDaten()
    {
      return (base.VereinsDaten() + "\nSportart: " + sportart + " wird trainiert von: " + trainer);
    }
  }

  class TierVerein : Verein
  {
    protected string tierart;
    protected string rasse;

    public TierVerein(string name, int anzahlMitglieder, double beitragshoehe,
                       string tierart, string rasse)
      : base(name, anzahlMitglieder, beitragshoehe)
    {
      this.tierart = tierart;
      this.rasse = rasse;
    }

    public override string VereinsDaten()
    {
      return (base.VereinsDaten() + "\nTierart: " + tierart + "/Rasse: " + rasse);
    }
  }
}